# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-8582 (libxml)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64701);
 script_cve_id("CVE-2004-0110", "CVE-2004-0989", "CVE-2009-2414", "CVE-2009-2416", "CAN-2004-0110", "CAN-2004-0989");
 script_version ("$");
 script_name("Fedora Core 11 FEDORA-2009-8582 (libxml)");

 desc = "The remote host is missing an update to libxml
announced via advisory FEDORA-2009-8582.

This library allows old Gnome-1 applications to manipulate XML files.

Update Information:

This update includes patches from RHEL-3 addressing a number of security
vulnerabilities:

- CVE-2004-0110 (arbitrary code execution via a long URL)
- CVE-2004-0989 (arbitrary code execution via a long URL)
- CVE-2009-2414 (stack consumption DoS vulnerabilities)
- CVE-2009-2416 (use-after-free DoS vulnerabilities)

ChangeLog:

* Wed Aug 12 2009 Paul Howarth  1:1.8.17-24
- renumber existing patches to free up low-numbered patches for EL-3 patches
- add patch for CAN-2004-0110 and CAN-2004-0989 (#139090)
- add patch for CVE-2009-2414 and CVE-2009-2416 (#515195, #515205)
* Sat Jul 25 2009 Fedora Release Engineering  1:1.8.17-23
- Rebuilt for https://fedoraproject.org/wiki/Fedora_12_Mass_Rebuild
* Mon Apr 20 2009 Paul Howarth  1:1.8.17-22
- rebuild for %{_isa} provides/requires

References:

[ 1 ] Bug #430644 - CVE-2004-0110 libxml2 long URL causes SEGV
https://bugzilla.redhat.com/show_bug.cgi?id=430644
[ 2 ] Bug #430645 - CVE-2004-0989 libxml2 various overflows
https://bugzilla.redhat.com/show_bug.cgi?id=430645
[ 3 ] Bug #515195 - CVE-2009-2414 libxml, libxml2: Stack overflow by parsing root XML element DTD definition
https://bugzilla.redhat.com/show_bug.cgi?id=515195
[ 4 ] Bug #515205 - CVE-2009-2416 libxml, libxml2: Pointer use-after-free flaws by parsing Notation and Enumeration attribute types
https://bugzilla.redhat.com/show_bug.cgi?id=515205

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update libxml' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-8582

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-8582 (libxml)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"libxml", rpm:"libxml~1.8.17~24.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxml-devel", rpm:"libxml-devel~1.8.17~24.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxml-debuginfo", rpm:"libxml-debuginfo~1.8.17~24.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
