# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-8812 (httpd)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64741);
 script_cve_id("CVE-2009-1891", "CVE-2009-1195", "CVE-2009-1890", "CVE-2009-1191");
 script_version ("$");
 script_name("Fedora Core 11 FEDORA-2009-8812 (httpd)");

 desc = "The remote host is missing an update to httpd
announced via advisory FEDORA-2009-8812.

The Apache HTTP Server is a powerful, efficient, and extensible
web server.

Update Information:

This update includes the latest release of the Apache HTTP Server, version
2.2.13, fixing several security issues:

* Fix a potential Denial-of-Service attack against mod_deflate or
  other modules, by forcing the server to consume CPU time in compressing
  a large file after a client disconnects.  (CVE-2009-1891)
* Prevent the Includes Option from being enabled in an
  .htaccess file if the AllowOverride restrictions do not permit it.
  (CVE-2009-1195)
* Fix a potential Denial-of-Service attack against mod_proxy
  in a reverse proxy configuration, where a remote attacker can force a proxy
  process to consume CPU time indefinitely. (CVE-2009-1890)
* mod_proxy_ajp: Avoid delivering content from a previous request
  which failed to send a request body.  (CVE-2009-1191)

Many bug fixes are also included; see the upstream
changelog for further details:

http://www.apache.org/dist/httpd/CHANGES_2.2.13

ChangeLog:

* Tue Aug 18 2009 Joe Orton  2.2.13-1
- update to 2.2.13

References:

[ 1 ] Bug #509375 - CVE-2009-1890 httpd: mod_proxy reverse proxy DoS (infinite loop)
https://bugzilla.redhat.com/show_bug.cgi?id=509375
[ 2 ] Bug #509125 - CVE-2009-1891 httpd: possible temporary DoS (CPU consumption) in mod_deflate
https://bugzilla.redhat.com/show_bug.cgi?id=509125
[ 3 ] Bug #489436 - CVE-2009-1195 AllowOverride Options=IncludesNoExec allows Options Includes
https://bugzilla.redhat.com/show_bug.cgi?id=489436

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update httpd' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-8812

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-8812 (httpd)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"httpd", rpm:"httpd~2.2.13~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"httpd-devel", rpm:"httpd-devel~2.2.13~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"httpd-manual", rpm:"httpd-manual~2.2.13~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"httpd-tools", rpm:"httpd-tools~2.2.13~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mod_ssl", rpm:"mod_ssl~2.2.13~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"httpd-debuginfo", rpm:"httpd-debuginfo~2.2.13~1.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
