# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-8888 (perl-Compress-Raw-Bzip2)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64728);
 script_cve_id("CVE-2009-1391", "CVE-2009-1884");
 script_version ("$");
 script_name("Fedora Core 10 FEDORA-2009-8888 (perl-Compress-Raw-Bzip2)");

 desc = "The remote host is missing an update to perl-Compress-Raw-Bzip2
announced via advisory FEDORA-2009-8888.

Update Information:

Off-by-one error in the bzinflate function in Bzip2.xs in the
Compress-Raw-Bzip2 module before 2.018 for Perl allows
context-dependent attackers to cause a denial of service
(application hang or crash) via a crafted bzip2 compressed
stream that triggers a buffer overflow, a related issue to CVE-2009-1391.

ChangeLog:

* Thu Aug 20 2009 Marcela Malov  - 2.020-1
- 518278 CVE-2009-1884, update to the latest release

References:

[ 1 ] Bug #518278 - CVE-2009-1884 perl-Compress-Raw-Bzip2: Off-by-one error in the bzinflate function - DoS (crash)
https://bugzilla.redhat.com/show_bug.cgi?id=518278

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update perl-Compress-Raw-Bzip2' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-8888

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-8888 (perl-Compress-Raw-Bzip2)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"perl-Compress-Raw", rpm:"perl-Compress-Raw~Bzip2~2.020", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Compress-Raw", rpm:"perl-Compress-Raw~Bzip2~debuginfo", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
