# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-9342 (libsilc)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64849);
 script_cve_id("CVE-2008-7160");
 script_version ("$");
 script_name("Fedora Core 11 FEDORA-2009-9342 (libsilc)");

 desc = "The remote host is missing an update to libsilc
announced via advisory FEDORA-2009-9342.

SILC Client Library libraries for clients to connect to SILC networks.

SILC (Secure Internet Live Conferencing) is a protocol which provides
secure conferencing services on the Internet over insecure channel.

ChangeLog:

* Fri Sep  4 2009 Stu Tomlinson  1.1.8-7
- Backport patch to fix stack corruption (CVE-2008-7160) (#521256)
* Fri Sep  4 2009 Stu Tomlinson  1.1.8-6
- Backport patch to fix additional string format vulnerabilities (#515648)

References:

[ 1 ] Bug #515648 - libsilc: format string vulnerability in client entry handling
https://bugzilla.redhat.com/show_bug.cgi?id=515648
[ 2 ] Bug #521256 - CVE-2008-7160 libsilc: stack corruption in SilcHttpServer on 64bit archs
https://bugzilla.redhat.com/show_bug.cgi?id=521256

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update libsilc' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-9342

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-9342 (libsilc)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"libsilc", rpm:"libsilc~1.1.8~7.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsilc-devel", rpm:"libsilc-devel~1.1.8~7.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsilc-doc", rpm:"libsilc-doc~1.1.8~7.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsilc-debuginfo", rpm:"libsilc-debuginfo~1.1.8~7.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
