# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-9550 (bugzilla)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64916);
 script_cve_id("CVE-2009-3125", "CVE-2009-3165", "CVE-2009-3166", "CVE-2009-1213");
 script_version ("$");
 script_name("Fedora Core 10 FEDORA-2009-9550 (bugzilla)");

 desc = "The remote host is missing an update to bugzilla
announced via advisory FEDORA-2009-9550.

Update Information:

Update to upstream version 3.2.5 fixing two SQL injection security flaws
(CVE-2009-3125, CVE-2009-3165) detailed in the upstream security advisory:
http://www.bugzilla.org/security/3.0.8/

ChangeLog:

* Fri Sep 11 2009 Emmanuel Seyman  - 3.2.5-1
- Update to 3.2.5 (CVE-2009-3125, CVE-2009-3165 and CVE-2009-3166)

References:

[ 1 ] Bug #522547 - major security issue bugfix release imminent
https://bugzilla.redhat.com/show_bug.cgi?id=522547

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update bugzilla' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-9550

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-9550 (bugzilla)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"bugzilla", rpm:"bugzilla~3.2.5~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bugzilla-contrib", rpm:"bugzilla-contrib~3.2.5~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bugzilla-doc", rpm:"bugzilla-doc~3.2.5~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
