#
#VID 09c92f3a-fd49-11da-995c-605724cdf281
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56974);
 script_cve_id("CVE-2006-2762");
 script_bugtraq_id(18175);
 script_version ("$");
 name = "FreeBSD Ports: WebCalendar";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: WebCalendar

CVE-2006-2762
PHP remote file inclusion vulnerability in includes/config.php in
WebCalendar 1.0.3 allows remote attackers to execute arbitrary PHP
code via a URL in the includedir parameter, which is remotely accessed
in an fopen call whose results are used to define a user_inc setting
that is used in an include_once call.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.securityfocus.com/archive/1/435379
http://www.securityfocus.com/archive/1/436263
http://www.vuxml.org/freebsd/09c92f3a-fd49-11da-995c-605724cdf281.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: WebCalendar";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"WebCalendar");
if(!isnull(bver) && revcomp(a:bver, b:"1.0.4")<0) {
    security_note(0, data:"Package WebCalendar version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
