#
#VID 8091fcea-f35e-11d8-81b0-000347a4fa7d
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52334);
 script_cve_id("CVE-2004-1170");
 script_bugtraq_id(11025);
 script_version ("$");
 name = "FreeBSD Ports: a2ps-a4";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   a2ps-a4
   a2ps-letter
   a2ps-letterdj

CVE-2004-1170
a2ps 4.13 allows remote attackers to execute arbitrary commands via
shell metacharacters in the filename.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.osvdb.org/9176
http://marc.theaimsgroup.com/?l=full-disclosure&m=109334851517137
http://www.vuxml.org/freebsd/8091fcea-f35e-11d8-81b0-000347a4fa7d.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: a2ps-a4";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"a2ps-a4");
if(!isnull(bver) && revcomp(a:bver, b:"4.13b_2")<0) {
    security_note(0, data:"Package a2ps-a4 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"a2ps-letter");
if(!isnull(bver) && revcomp(a:bver, b:"4.13b_2")<0) {
    security_note(0, data:"Package a2ps-letter version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"a2ps-letterdj");
if(!isnull(bver) && revcomp(a:bver, b:"4.13b_2")<0) {
    security_note(0, data:"Package a2ps-letterdj version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
