#
#VID ca6c8f35-0a5f-11d9-ad6f-00061bc2ad93
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52383);
 script_cve_id("CVE-2004-0492");
 script_version ("$");
 name = "FreeBSD Ports: apache";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   apache
   apache13-ssl
   apache13-modssl
   apache13+ipv6
   apache13-modperl

CVE-2004-0492
Heap-based buffer overflow in proxy_util.c for mod_proxy in Apache
1.3.25 to 1.3.31 allows remote attackers to cause a denial of service
(process crash) and possibly execute arbitrary code via a negative
Content-Length HTTP header field, which causes a large amount of data
to be copied.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.guninski.com/modproxy1.html
http://www.vuxml.org/freebsd/ca6c8f35-0a5f-11d9-ad6f-00061bc2ad93.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: apache";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"apache");
if(!isnull(bver) && revcomp(a:bver, b:"1.3.31_1")<0) {
    security_note(0, data:"Package apache version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"apache13-ssl");
if(!isnull(bver) && revcomp(a:bver, b:"1.3.29.1.53_2")<=0) {
    security_note(0, data:"Package apache13-ssl version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"apache13-modssl");
if(!isnull(bver) && revcomp(a:bver, b:"1.3.31+2.8.18_4")<0) {
    security_note(0, data:"Package apache13-modssl version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"apache13+ipv6");
if(!isnull(bver) && revcomp(a:bver, b:"1.3.29_2")<=0) {
    security_note(0, data:"Package apache13+ipv6 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"apache13-modperl");
if(!isnull(bver) && revcomp(a:bver, b:"1.3.31")<=0) {
    security_note(0, data:"Package apache13-modperl version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
