#
#VID ef3306fc-8f9b-11db-ab33-000e0c2e438a
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57727);
 script_cve_id("CVE-2006-4095", "CVE-2006-4096");
 script_version ("$");
 name = "FreeBSD Ports: bind9";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: bind9

CVE-2006-4095
BIND before 9.2.6-P1 and 9.3.x before 9.3.2-P1 allows remote attackers
to cause a denial of service (crash) via certain SIG queries, which
cause an assertion failure when multiple RRsets are returned.

CVE-2006-4096
BIND before 9.2.6-P1 and 9.3.x before 9.3.2-P1 allows remote attackers to
cause a denial of service (crash) via a flood of recursive queries, which
cause an INSIST failure when the response is received after the recursion
queue is empty.

Solution:
Update your system with the appropriate patches or
software upgrades.


Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: bind9";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"bind9");
if(!isnull(bver) && revcomp(a:bver, b:"9.0")>0 && revcomp(a:bver, b:"9.3.2.1")<0) {
    security_note(0, data:"Package bind9 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
