#
#VID 92140bc9-7bde-11da-8ec4-0002b3b60e4c
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56105);
 script_bugtraq_id(16171);
 script_cve_id("CVE-2005-4591");
 script_version ("$");
 name = "FreeBSD Ports: bogofilter";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: bogofilter

CVE-2005-4591
Heap-based buffer overflow in bogofilter 0.96.2, 0.95.2, 0.94.14,
0.94.12, and other versions from 0.93.5 to 0.96.2, when using Unicode
databases, allows remote attackers to cause a denial of service
(crash) and possibly execute arbitrary code via 'invalid input
sequences' that lead to heap corruption when bogofilter or bogolexer
converts character sets.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://bogofilter.sourceforge.net/security/bogofilter-SA-2005-01
http://www.vuxml.org/freebsd/92140bc9-7bde-11da-8ec4-0002b3b60e4c.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: bogofilter";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"bogofilter");
if(!isnull(bver) && revcomp(a:bver, b:"0.93.5")>=0 && revcomp(a:bver, b:"0.96.3")<0) {
    security_note(0, data:"Package bogofilter version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
