#
#VID 063399fc-f6d6-11dc-bcee-001c2514716c
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(60632);
 script_cve_id("CVE-2008-1372");
 script_bugtraq_id(28286);
 script_version ("$");
 name = "FreeBSD Ports: bzip2";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: bzip2

CVE-2008-1372
bzlib.c in bzip2 before 1.0.5 allows user-assisted remote attackers to
cause a denial of service (crash) via a crafted file that triggers a
buffer over-read, as demonstrated by the PROTOS GENOME test suite for
Archive Formats.

Solution:
Update your system with the appropriate patches or
software upgrades.

https://www.cert.fi/haavoittuvuudet/joint-advisory-archive-formats.html
http://www.ee.oulu.fi/research/ouspg/protos/testing/c10/archive/
http://www.vuxml.org/freebsd/063399fc-f6d6-11dc-bcee-001c2514716c.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: bzip2";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"bzip2");
if(!isnull(bver) && revcomp(a:bver, b:"1.0.5")<0) {
    security_note(0, data:"Package bzip2 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
