#
#VID 7850a238-680a-11d9-a9e7-0001020eed82
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52231);
 script_cve_id("CVE-2004-1268", "CVE-2004-1269", "CVE-2004-1270");
 script_bugtraq_id(12007,12004);
 script_version ("$");
 name = "FreeBSD Ports: cups-lpr, fr-cups-lpr";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   cups-lpr
   fr-cups-lpr

CVE-2004-1268
lppasswd in CUPS 1.1.22 ignores write errors when modifying the CUPS
passwd file, which allows local users to corrupt the file by filling
the associated file system and triggering the write errors.

CVE-2004-1269
lppasswd in CUPS 1.1.22 does not remove the passwd.new file if it
encounters a file-size resource limit while writing to passwd.new,
which causes subsequent invocations of lppasswd to fail.

CVE-2004-1270
lppasswd in CUPS 1.1.22, when run in environments that do not ensure
that file descriptors 0, 1, and 2 are open when lppasswd is called,
does not verify that the passwd.new file is different from STDERR,
which allows local users to control output to passwd.new via certain
user input that triggers an error message.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.cups.org/str.php?L1023
http://tigger.uic.edu/~jlongs2/holes/cups2.txt
http://www.vuxml.org/freebsd/7850a238-680a-11d9-a9e7-0001020eed82.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: cups-lpr, fr-cups-lpr";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"cups-lpr");
if(!isnull(bver) && revcomp(a:bver, b:"1.1.23")<0) {
    security_note(0, data:"Package cups-lpr version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"fr-cups-lpr");
if(!isnull(bver) && revcomp(a:bver, b:"1.1.23")<0) {
    security_note(0, data:"Package fr-cups-lpr version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
