#
#VID b8e361b8-b7ff-11da-8414-0013d4a4a40e
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56451);
 script_bugtraq_id(17154);
 script_cve_id("CVE-2006-1061");
 script_version ("$");
 name = "FreeBSD Ports: curl";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: curl

CVE-2006-1061
Heap-based buffer overflow in cURL and libcURL 7.15.0 through 7.15.2
allows remote attackers to execute arbitrary commands via a TFTP URL
(tftp://) with a valid hostname and a long path.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://curl.haxx.se/docs/adv_20060320.html
http://www.vuxml.org/freebsd/b8e361b8-b7ff-11da-8414-0013d4a4a40e.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: curl";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"curl");
if(!isnull(bver) && revcomp(a:bver, b:"7.15.0")>=0 && revcomp(a:bver, b:"7.15.3")<0) {
    security_note(0, data:"Package curl version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
