#
#VID 012b495c-9d51-11de-8d20-001bd3385381
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 012b495c-9d51-11de-8d20-001bd3385381
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64898);
 script_cve_id("CVE-2009-2632");
 script_bugtraq_id(36296);
 script_version ("$");
 script_name("FreeBSD Ports: cyrus-imapd");

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: cyrus-imapd

CVE-2009-2632
Buffer overflow in the SIEVE script component (sieve/script.c) in
cyrus-imapd in Cyrus IMAP Server 2.2.13 and 2.3.14 allows local users
to execute arbitrary code and read or modify arbitrary messages via a
crafted SIEVE script, related to the incorrect use of the sizeof
operator for determining buffer length, combined with an integer
signedness error.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.kb.cert.org/vuls/id/336053
http://www.debian.org/security/2009/dsa-1881
http://www.vuxml.org/freebsd/012b495c-9d51-11de-8d20-001bd3385381.html

Risk factor : High";

 script_description(desc);

 script_summary("FreeBSD Ports: cyrus-imapd");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("FreeBSD Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"cyrus-imapd");
if(!isnull(bver) && revcomp(a:bver, b:"2.2.0")>0 && revcomp(a:bver, b:"2.2.13_6")<0) {
    security_note(0, data:"Package cyrus-imapd version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"2.3.0")>0 && revcomp(a:bver, b:"2.3.14_2")<0) {
    security_note(0, data:"Package cyrus-imapd version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
