#
#VID e848a92f-0e7d-11de-92de-000bcdc1757a
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID e848a92f-0e7d-11de-92de-000bcdc1757a
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63564);
 script_cve_id("CVE-2008-5985", "CVE-2008-5983");
 script_version ("$");
 name = "FreeBSD Ports: epiphany";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: epiphany

CVE-2008-5985
Untrusted search path vulnerability in the Python interface in
Epiphany 2.22.3, and possibly other versions, allows local users to
execute arbitrary code via a Trojan horse Python file in the current
working directory, related to a vulnerability in the PySys_SetArgv
function (CVE-2008-5983).

CVE-2008-5983
Untrusted search path vulnerability in the PySys_SetArgv API function
in Python 2.6 and earlier, and possibly later versions, prepends an
empty string to sys.path when the argv[0] argument does not contain a
path separator, which might allow local users to execute arbitrary
code via a Trojan horse Python file in the current working directory.

Solution:
Update your system with the appropriate patches or
software upgrades.


Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: epiphany";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"epiphany");
if(!isnull(bver) && revcomp(a:bver, b:"2.24.2.1")<0) {
    security_note(0, data:"Package epiphany version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
