#
#VID 7884d56f-f7a1-11d8-9837-000c41e2cdad
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52412);
 script_cve_id("CVE-2004-0494");
 script_bugtraq_id(10864);
 script_version ("$");
 name = "FreeBSD Ports: gnomevfs2";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   gnomevfs2
   gnomevfs
   mc

CVE-2004-0494
Multiple extfs backend scripts for GNOME virtual file system (VFS)
before 1.0.1 may allow remote attackers to perform certain
unauthorized actions via a gnome-vfs URI.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.ciac.org/ciac/bulletins/o-194.shtml
http://xforce.iss.net/xforce/xfdb/16897
https://bugzilla.redhat.com/bugzilla/show_bug.cgi?id=127263
http://www.vuxml.org/freebsd/7884d56f-f7a1-11d8-9837-000c41e2cdad.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: gnomevfs2";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"gnomevfs2");
if(!isnull(bver) && revcomp(a:bver, b:"2.6.2_1")<0) {
    security_note(0, data:"Package gnomevfs2 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"gnomevfs");
if(!isnull(bver) && revcomp(a:bver, b:"1.0.5_6")<0) {
    security_note(0, data:"Package gnomevfs version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"mc");
if(!isnull(bver) && revcomp(a:bver, b:"4.6.0_12")<=0) {
    security_note(0, data:"Package mc version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
