#
#VID 63fe4189-9f97-11da-ac32-0001020eed82
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56261);
 script_bugtraq_id(16663);
 script_cve_id("CVE-2006-0455");
 script_version ("$");
 name = "FreeBSD Ports: gnupg";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: gnupg

CVE-2006-0455
gpgv in GnuPG 1.4.x before 1.4.2.1, when using unattended signature
verification, returns a 0 exit code in certain cases even when the
detached signature file does not carry a signature, which could cause
programs that use gpgv to assume that the sigbnature verification has
succeeded.  Note: this also occurs when running the equivalent command
'gpg --verify'.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://marc.theaimsgroup.com/?l=gnupg-devel&m=113999098729114
http://www.vuxml.org/freebsd/63fe4189-9f97-11da-ac32-0001020eed82.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: gnupg";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"gnupg");
if(!isnull(bver) && revcomp(a:bver, b:"1.4.2.1")<0) {
    security_note(0, data:"Package gnupg version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
