#
#VID b31a1088-460f-11de-a11a-0022156e8794
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID b31a1088-460f-11de-a11a-0022156e8794
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64785);
 script_cve_id("CVE-2009-1415", "CVE-2009-1416", "CVE-2009-1417");
 script_bugtraq_id(34783);
 script_version ("$");
 script_name("FreeBSD Ports: gnutls");

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   gnutls
   gnutls-devel

CVE-2009-1415
lib/pk-libgcrypt.c in libgnutls in GnuTLS before 2.6.6 does not
properly handle invalid DSA signatures, which allows remote attackers
to cause a denial of service (application crash) and possibly have
unspecified other impact via a malformed DSA key that triggers a (1)
free of an uninitialized pointer or (2) double free.

CVE-2009-1416
lib/gnutls_pk.c in libgnutls in GnuTLS 2.5.0 through 2.6.5 generates
RSA keys stored in DSA structures, instead of the intended DSA keys,
which might allow remote attackers to spoof signatures on certificates
or have unspecified other impact by leveraging an invalid DSA key.

CVE-2009-1417
gnutls-cli in GnuTLS before 2.6.6 does not verify the activation and
expiration times of X.509 certificates, which allows remote attackers
to successfully present a certificate that is (1) not yet valid or (2)
no longer valid, related to lack of time checks in the
_gnutls_x509_verify_certificate function in lib/x509/verify.c in
libgnutls_x509, as used by (a) Exim, (b) OpenLDAP, and (c) libsoup.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://article.gmane.org/gmane.comp.encryption.gpg.gnutls.devel/3515
http://article.gmane.org/gmane.comp.encryption.gpg.gnutls.devel/3516
http://article.gmane.org/gmane.comp.encryption.gpg.gnutls.devel/3517
http://www.vuxml.org/freebsd/b31a1088-460f-11de-a11a-0022156e8794.html

Risk factor : High";

 script_description(desc);

 script_summary("FreeBSD Ports: gnutls");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("FreeBSD Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"gnutls");
if(!isnull(bver) && revcomp(a:bver, b:"2.6.6")<0) {
    security_note(0, data:"Package gnutls version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"gnutls-devel");
if(!isnull(bver) && revcomp(a:bver, b:"2.7.8")<0) {
    security_note(0, data:"Package gnutls-devel version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
