#
#VID c444c8b7-7169-11de-9ab7-000c29a67389
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID c444c8b7-7169-11de-9ab7-000c29a67389
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64447);
 script_cve_id("CVE-2009-0692");
 script_version ("$");
 name = "FreeBSD Ports: isc-dhcp31-client";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   isc-dhcp31-client
   isc-dhcp30-client

CVE-2009-0692
Stack-based buffer overflow in the script_write_params method in
client/dhclient.c in ISC DHCP dhclient 4.1 before 4.1.0p1, 4.0 before
4.0.1p1, 3.1 before 3.1.2p1, 3.0, and 2.0 allows remote DHCP servers
to execute arbitrary code via a crafted subnet-mask option.

Solution:
Update your system with the appropriate patches or
software upgrades.

https://www.isc.org/node/468
http://secunia.com/advisories/35785
http://www.kb.cert.org/vuls/id/410676
http://www.vuxml.org/freebsd/c444c8b7-7169-11de-9ab7-000c29a67389.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: isc-dhcp31-client";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"isc-dhcp31-client");
if(!isnull(bver) && revcomp(a:bver, b:"3.1.1")<=0) {
    security_note(0, data:"Package isc-dhcp31-client version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"isc-dhcp30-client");
if(!isnull(bver) && revcomp(a:bver, b:"3.0.7")<=0) {
    security_note(0, data:"Package isc-dhcp30-client version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
