#
#VID c93e4d41-75c5-11dc-b903-0016179b2dd5
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58786);
 script_cve_id("CVE-2007-5232");
 script_version ("$");
 name = "FreeBSD Ports: jdk";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   jdk
   linux-blackdown-jdk
   linux-sun-jdk

=====

Solution:
Update your system with the appropriate patches or
software upgrades.

http://sunsolve.sun.com/search/document.do?assetkey=1-26-103079-1
http://www.vuxml.org/freebsd/c93e4d41-75c5-11dc-b903-0016179b2dd5.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: jdk";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"jdk");
if(!isnull(bver) && revcomp(a:bver, b:"1.3.0")>=0 && revcomp(a:bver, b:"1.6.0.3p3")<0) {
    security_note(0, data:"Package jdk version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"1.5.0,1")>=0 && revcomp(a:bver, b:"1.5.0.13p7,1")<0) {
    security_note(0, data:"Package jdk version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux-blackdown-jdk");
if(!isnull(bver) && revcomp(a:bver, b:"1.3.0")>=0) {
    security_note(0, data:"Package linux-blackdown-jdk version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux-sun-jdk");
if(!isnull(bver) && revcomp(a:bver, b:"1.3.0")>=0 && revcomp(a:bver, b:"1.3.1.20")<0) {
    security_note(0, data:"Package linux-sun-jdk version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"1.4.0")>=0 && revcomp(a:bver, b:"1.4.2.16")<0) {
    security_note(0, data:"Package linux-sun-jdk version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"1.5.0")>=0 && revcomp(a:bver, b:"1.6.0.03")<0) {
    security_note(0, data:"Package linux-sun-jdk version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"1.5.0.b1,1")>=0 && revcomp(a:bver, b:"1.5.0.13,2")<0) {
    security_note(0, data:"Package linux-sun-jdk version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
