#
#VID 94edff42-d93d-11de-a434-0211d880e350
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 94edff42-d93d-11de-a434-0211d880e350
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66340);
 script_cve_id("CVE-2008-1420", "CVE-2009-3379");
 script_version ("$Revision$");
 script_name("FreeBSD Ports: libvorbis");

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: libvorbis

CVE-2008-1420
Integer overflow in residue partition value (aka partvals) evaluation
in Xiph.org libvorbis 1.2.0 and earlier allows remote attackers to
execute arbitrary code via a crafted OGG file, which triggers a heap
overflow.

CVE-2009-3379
Multiple unspecified vulnerabilities in libvorbis, as used in Mozilla
Firefox 3.5.x before 3.5.4, allow remote attackers to cause a denial
of service (application crash) or possibly execute arbitrary code via
unknown vectors.  NOTE: this might overlap CVE-2009-2663.

Solution:
Update your system with the appropriate patches or
software upgrades.


Risk factor : High";

 script_description(desc);

 script_summary("FreeBSD Ports: libvorbis");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("FreeBSD Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"libvorbis");
if(!isnull(bver) && revcomp(a:bver, b:"1.2.3_1,3")<0) {
    security_note(0, data:"Package libvorbis version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
