#
#VID 3c1a672e-e508-11de-9f4a-001b2134ef46
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 3c1a672e-e508-11de-9f4a-001b2134ef46
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66523);
 script_cve_id("CVE-2009-3794", "CVE-2009-3796", "CVE-2009-3797", "CVE-2009-3798", "CVE-2009-3799", "CVE-2009-3800", "CVE-2009-3951");
 script_version ("$Revision$");
 script_name("FreeBSD Ports: linux-flashplugin");

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   linux-flashplugin
   linux-f8-flashplugin
   linux-f10-flashplugin

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.zerodayinitiative.com/advisories/ZDI-09-092/
http://www.zerodayinitiative.com/advisories/ZDI-09-093/
http://www.adobe.com/support/security/bulletins/apsb09-19.html
http://www.vuxml.org/freebsd/3c1a672e-e508-11de-9f4a-001b2134ef46.html

Risk factor : High";

 script_description(desc);

 script_summary("FreeBSD Ports: linux-flashplugin");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("FreeBSD Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"linux-flashplugin");
if(!isnull(bver) && revcomp(a:bver, b:"9.0r260")<0) {
    security_note(0, data:"Package linux-flashplugin version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux-f8-flashplugin");
if(!isnull(bver) && revcomp(a:bver, b:"10.0r42")<0) {
    security_note(0, data:"Package linux-f8-flashplugin version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux-f10-flashplugin");
if(!isnull(bver) && revcomp(a:bver, b:"10.0r42")<0) {
    security_note(0, data:"Package linux-f10-flashplugin version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
