#
#VID fc4d0ae8-3fa3-11de-a3fd-0030843d3802
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID fc4d0ae8-3fa3-11de-a3fd-0030843d3802
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64008);
 script_cve_id("CVE-2009-0260", "CVE-2009-0312");
 script_version ("$");
 name = "FreeBSD Ports: moinmoin";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: moinmoin

CVE-2009-0260
Multiple cross-site scripting (XSS) vulnerabilities in
action/AttachFile.py in MoinMoin before 1.8.1 allow remote attackers
to inject arbitrary web script or HTML via an AttachFile action to the
WikiSandBox component with (1) the rename parameter or (2) the drawing
parameter (aka the basename variable).

CVE-2009-0312
Cross-site scripting (XSS) vulnerability in the antispam feature
(security/antispam.py) in MoinMoin 1.7 and 1.8.1 allows remote
attackers to inject arbitrary web script or HTML via crafted,
disallowed content.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://moinmo.in/SecurityFixes
http://secunia.com/advisories/33593
http://www.vuxml.org/freebsd/fc4d0ae8-3fa3-11de-a3fd-0030843d3802.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: moinmoin";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"moinmoin");
if(!isnull(bver) && revcomp(a:bver, b:"1.8.2")<0) {
    security_note(0, data:"Package moinmoin version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
