#
#VID 877e918e-5362-11d9-96d4-00065be4b5b6
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52253);
 script_cve_id("CVE-2004-1284");
 script_bugtraq_id(11958);
 script_version ("$");
 name = "FreeBSD Ports: mpg123, mpg123-nas, mpg123-esound";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   mpg123
   mpg123-nas
   mpg123-esound

CVE-2004-1284
Buffer overflow in the find_next_file function in playlist.c for
mpg123 0.59r allows remote attackers to execute arbitrary code via a
crafted MP3 playlist.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://tigger.uic.edu/~jlongs2/holes/mpg123.txt
http://secunia.com/advisories/13511/
http://xforce.iss.net/xforce/xfdb/18626
http://marc.theaimsgroup.com/?l=bugtraq&m=110321888413132
http://www.vuxml.org/freebsd/877e918e-5362-11d9-96d4-00065be4b5b6.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: mpg123, mpg123-nas, mpg123-esound";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"mpg123");
if(!isnull(bver) && revcomp(a:bver, b:"0.59r_15")<=0) {
    security_note(0, data:"Package mpg123 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"mpg123-nas");
if(!isnull(bver) && revcomp(a:bver, b:"0.59r_15")<=0) {
    security_note(0, data:"Package mpg123-nas version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"mpg123-esound");
if(!isnull(bver) && revcomp(a:bver, b:"0.59r_15")<=0) {
    security_note(0, data:"Package mpg123-esound version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
