#
#VID 5ccb1c14-e357-11dd-a765-0030843d3802
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 5ccb1c14-e357-11dd-a765-0030843d3802
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63240);
 script_cve_id("CVE-2008-3162");
 script_bugtraq_id(30157);
 script_version ("$");
 name = "mplayer -- vulnerability in STR files processor";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   mplayer
   mplayer-esound
   mplayer-gtk
   mplayer-gtk-esound
   mplayer-gtk2
   mplayer-gtk2-esound

CVE-2008-3162
Stack-based buffer overflow in the str_read_packet function in
libavformat/psxstr.c in FFmpeg before r13993 allows remote attackers
to cause a denial of service (application crash) or execute arbitrary
code via a crafted STR file that interleaves audio and video sectors.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://secunia.com/advisories/30994
https://roundup.mplayerhq.hu/roundup/ffmpeg/issue311
http://www.vuxml.org/freebsd/5ccb1c14-e357-11dd-a765-0030843d3802.html

Risk factor : High";

 script_description(desc);

 summary = "mplayer -- vulnerability in STR files processor";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"mplayer");
if(!isnull(bver) && revcomp(a:bver, b:"0.99.11_10")<0) {
    security_note(0, data:"Package mplayer version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"mplayer-esound");
if(!isnull(bver) && revcomp(a:bver, b:"0.99.11_10")<0) {
    security_note(0, data:"Package mplayer-esound version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"mplayer-gtk");
if(!isnull(bver) && revcomp(a:bver, b:"0.99.11_10")<0) {
    security_note(0, data:"Package mplayer-gtk version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"mplayer-gtk-esound");
if(!isnull(bver) && revcomp(a:bver, b:"0.99.11_10")<0) {
    security_note(0, data:"Package mplayer-gtk-esound version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"mplayer-gtk2");
if(!isnull(bver) && revcomp(a:bver, b:"0.99.11_10")<0) {
    security_note(0, data:"Package mplayer-gtk2 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"mplayer-gtk2-esound");
if(!isnull(bver) && revcomp(a:bver, b:"0.99.11_10")<0) {
    security_note(0, data:"Package mplayer-gtk2-esound version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
