#
#VID c5519420-cec2-11d8-8898-000d6111a684
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52436);
 script_bugtraq_id(10246);
 script_cve_id("CVE-2004-0519");
 script_version ("$");
 name = "FreeBSD Ports: openwebmail";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   openwebmail
   ilohamail

CVE-2004-0519
Multiple cross-site scripting (XSS) vulnerabilities in SquirrelMail
1.4.2 allow remote attackers to execute arbitrary script as other
users and possibly steal authentication information via multiple
attack vectors, including the mailbox parameter in compose.php.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.rs-labs.com/adv/RS-Labs-Advisory-2004-2.txt
http://www.freebsd.org/ports/portaudit/89a0de27-bf66-11d8-a252-02e0185c0b53.html
http://www.freebsd.org/ports/portaudit/911f1b19-bd20-11d8-84f9-000bdb1444a4.html
http://www.freebsd.org/ports/portaudit/c3e56efa-c42f-11d8-864c-02e0185c0b53.html
http://www.vuxml.org/freebsd/c5519420-cec2-11d8-8898-000d6111a684.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: openwebmail";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"openwebmail");
if(!isnull(bver) && revcomp(a:bver, b:"2.32")<=0) {
    security_note(0, data:"Package openwebmail version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ilohamail");
if(!isnull(bver) && revcomp(a:bver, b:"0.8.13")<0) {
    security_note(0, data:"Package ilohamail version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
