#
#VID b1ca65e6-5aaf-11de-bc9b-0030843d3802
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID b1ca65e6-5aaf-11de-bc9b-0030843d3802
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64266);
 script_cve_id("CVE-2009-1373", "CVE-2009-1374", "CVE-2009-1375", "CVE-2009-1376");
 script_bugtraq_id(35067);
 script_version ("$");
 name = "FreeBSD Ports: pidgin, libpurple, finch";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   pidgin
   libpurple
   finch

CVE-2009-1373
Buffer overflow in the XMPP SOCKS5 bytestream server in Pidgin
(formerly Gaim) before 2.5.6 allows remote authenticated users to
execute arbitrary code via vectors involving an outbound XMPP file
transfer.  NOTE: some of these details are obtained from third party
information.
CVE-2009-1374
Buffer overflow in the decrypt_out function in Pidgin (formerly Gaim)
before 2.5.6 allows remote attackers to cause a denial of service
(application crash) via a QQ packet.
CVE-2009-1375
The PurpleCircBuffer implementation in Pidgin (formerly Gaim) before
2.5.6 does not properly maintain a certain buffer, which allows remote
attackers to cause a denial of service (memory corruption and
application crash) via vectors involving the (1) XMPP or (2) Sametime
protocol.
CVE-2009-1376
Multiple integer overflows in the msn_slplink_process_msg functions in
the MSN protocol handler in (1) libpurple/protocols/msn/slplink.c and
(2) libpurple/protocols/msnp9/slplink.c in Pidgin (formerly Gaim)
before 2.5.6 on 32-bit platforms allow remote attackers to execute
arbitrary code via a malformed SLP message with a crafted offset
value, leading to buffer overflows.  NOTE: this issue exists because
of an incomplete fix for CVE-2008-2927.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://secunia.com/advisories/35194/
http://www.pidgin.im/news/security/?id=29
http://www.pidgin.im/news/security/?id=30
http://www.pidgin.im/news/security/?id=32
http://www.vuxml.org/freebsd/b1ca65e6-5aaf-11de-bc9b-0030843d3802.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: pidgin, libpurple, finch";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"pidgin");
if(!isnull(bver) && revcomp(a:bver, b:"2.5.6")<0) {
    security_note(0, data:"Package pidgin version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"libpurple");
if(!isnull(bver) && revcomp(a:bver, b:"2.5.6")<0) {
    security_note(0, data:"Package libpurple version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"finch");
if(!isnull(bver) && revcomp(a:bver, b:"2.5.6")<0) {
    security_note(0, data:"Package finch version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
