#
#VID 39bd57e6-5d83-11d8-80e3-0020ed76ef5a
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52525);
 script_cve_id("CVE-2003-0720", "CVE-2003-0721");
 script_version ("$");
 name = "FreeBSD Ports: pine, zh-pine, iw-pine";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   pine
   zh-pine
   iw-pine

CVE-2003-0720
Buffer overflow in PINE before 4.58 allows remote attackers to execute
arbitrary code via a malformed message/external-body MIME type.

CVE-2003-0721
Integer signedness error in rfc2231_get_param from strings.c in PINE
before 4.58 allows remote attackers to execute arbitrary code via an
email that causes an out-of-bounds array access using a negative
number.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.idefense.com/application/poi/display?id=5
http://www.vuxml.org/freebsd/39bd57e6-5d83-11d8-80e3-0020ed76ef5a.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: pine, zh-pine, iw-pine";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"pine");
if(!isnull(bver) && revcomp(a:bver, b:"4.58")<0) {
    security_note(0, data:"Package pine version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"zh-pine");
if(!isnull(bver) && revcomp(a:bver, b:"4.58")<0) {
    security_note(0, data:"Package zh-pine version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"iw-pine");
if(!isnull(bver) && revcomp(a:bver, b:"4.58")<0) {
    security_note(0, data:"Package iw-pine version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
