#
#VID bc20510f-4dd4-11dd-93e7-0211d880e350
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(61286);
 script_cve_id("CVE-2008-2950");
 script_version ("$");
 name = "FreeBSD Ports: poppler";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: poppler

CVE-2008-2950
The Page destructor in Page.cc in libpoppler in Poppler 0.8.4 and
earlier deletes a pageWidgets object even if it is not initialized by
a Page constructor, which allows remote attackers to execute arbitrary
code via a crafted PDF document.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://milw0rm.com/exploits/6032
http://www.vuxml.org/freebsd/bc20510f-4dd4-11dd-93e7-0211d880e350.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: poppler";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"poppler");
if(!isnull(bver) && revcomp(a:bver, b:"0.8.4_2")<0) {
    security_note(0, data:"Package poppler version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
