#
#VID a413ed94-836e-11d9-a9e7-0001020eed82
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52179);
 script_cve_id("CVE-2005-0467");
 script_bugtraq_id(12601);
 script_version ("$");
 name = "FreeBSD Ports: putty";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: putty

CVE-2005-0467
Multiple integer overflows in the (1) sftp_pkt_getstring and (2)
fxp_readdir_recv functions in the PSFTP and PSCP clients for PuTTY
0.56, and possibly earlier versions, allow remote malicious web sites
to execute arbitrary code via SFTP responses that corrupt the heap
after insufficient memory has been allocated.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.chiark.greenend.org.uk/~sgtatham/putty/wishlist/vuln-sftp-readdir.html
http://www.chiark.greenend.org.uk/~sgtatham/putty/wishlist/vuln-sftp-string.html
http://lists.tartarus.org/pipermail/putty-announce/2005/000012.html
http://marc.theaimsgroup.com/?l=bugtraq&m=110902510713763
http://www.vuxml.org/freebsd/a413ed94-836e-11d9-a9e7-0001020eed82.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: putty";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"putty");
if(!isnull(bver) && revcomp(a:bver, b:"0.57")<0) {
    security_note(0, data:"Package putty version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
