#
#VID 90064567-28b1-11db-844d-000c6ec775d9
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57259);
 script_version ("$");
 name = "FreeBSD Ports: rubygem-rails";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: rubygem-rails

Solution:
Update your system with the appropriate patches or
software upgrades.

http://weblog.rubyonrails.org/2006/8/10/rails-1-1-6-backports-and-full-disclosure
http://www.vuxml.org/freebsd/90064567-28b1-11db-844d-000c6ec775d9.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: rubygem-rails";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"rubygem-rails");
if(!isnull(bver) && revcomp(a:bver, b:"1.1.0")>=0 && revcomp(a:bver, b:"1.1.3")<0) {
    security_note(0, data:"Package rubygem-rails version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"1.1.4")>=0 && revcomp(a:bver, b:"1.1.6")<0) {
    security_note(0, data:"Package rubygem-rails version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
