#
#VID af9018b6-a4f5-11da-bb41-0011433a9404
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56314);
 script_cve_id("CVE-2006-0377", "CVE-2006-0195", "CVE-2006-0188");
 script_version ("$");
 name = "FreeBSD Ports: squirrelmail";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: squirrelmail

CVE-2006-0377
CRLF injection vulnerability in SquirrelMail 1.4.0 to 1.4.5 allows
remote attackers to inject arbitrary IMAP commands via newline
characters in the mailbox parameter of the sqimap_mailbox_select
command, aka 'IMAP injection.'

CVE-2006-0195
Interpretation conflict in the MagicHTML filter in SquirrelMail 1.4.0
to 1.4.5 allows remote attackers to conduct cross-site scripting (XSS)
attacks via style sheet specifiers with invalid (1) '/*' and '*/'
comments, or (2) a newline in a 'url' specifier, which is processed by
certain web browsers including Internet Explorer.

CVE-2006-0188
webmail.php in SquirrelMail 1.4.0 to 1.4.5 allows remote attackers to
inject arbitrary web pages into the right frame via a URL in the
right_frame parameter.  NOTE: this has been called a cross-site
scripting (XSS) issue, but it is different than what is normally
identified as XSS.

Solution:
Update your system with the appropriate patches or
software upgrades.


Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: squirrelmail";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"squirrelmail");
if(!isnull(bver) && revcomp(a:bver, b:"1.4.6")<0) {
    security_note(0, data:"Package squirrelmail version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
