#
#VID bd9fc2bf-5ffe-11d9-a11a-000a95bc6fae
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52250);
 script_cve_id("CVE-2004-1138");
 script_version ("$");
 name = "FreeBSD Ports: vim, vim-lite, vim+ruby";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   vim
   vim-lite
   vim+ruby

CVE-2004-1138
VIM before 6.3 and gVim before 6.3 allow local users to execute
arbitrary commands via a file containing a crafted modeline that is
executed when the file is viewed using options such as (1) termcap,
(2) printdevice, (3) titleold, (4) filetype, (5) syntax, (6)
backupext, (7) keymap, (8) patchmode, or (9) langmenu.

Solution:
Update your system with the appropriate patches or
software upgrades.

ftp://ftp.vim.org/pub/vim/patches/6.3/6.3.045
http://groups.yahoo.com/group/vimdev/message/38084
http://www.vuxml.org/freebsd/bd9fc2bf-5ffe-11d9-a11a-000a95bc6fae.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: vim, vim-lite, vim+ruby";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"vim");
if(!isnull(bver) && revcomp(a:bver, b:"6.3.45")<0) {
    security_note(0, data:"Package vim version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"vim-lite");
if(!isnull(bver) && revcomp(a:bver, b:"6.3.45")<0) {
    security_note(0, data:"Package vim-lite version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"vim+ruby");
if(!isnull(bver) && revcomp(a:bver, b:"6.3.45")<0) {
    security_note(0, data:"Package vim+ruby version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
