#
#VID 9347d82d-9a66-11db-b271-000e35248ad7
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57747);
 script_cve_id("CVE-2006-6772");
 script_bugtraq_id(21735);
 script_version ("$");
 name = "FreeBSD Ports: w3m, w3m-img, w3m-m17n, w3m-m17n-img, ja-w3m, ja-w3m-img";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   w3m w3m-img w3m-m17n w3m-m17n-img ja-w3m ja-w3m-img

Solution:
Update your system with the appropriate patches or
software upgrades.

http://sourceforge.net/tracker/index.php?func=detail&aid=1612792&group_id=39518&atid=425439
http://secunia.com/advisories/23492/
http://www.vuxml.org/freebsd/9347d82d-9a66-11db-b271-000e35248ad7.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: w3m, w3m-img, w3m-m17n, w3m-m17n-img, ja-w3m, ja-w3m-img";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"w3m");
if(!isnull(bver) && revcomp(a:bver, b:"0.5.1_6")<0) {
    security_note(0, data:"Package w3m version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"w3m-img");
if(!isnull(bver) && revcomp(a:bver, b:"0.5.1_6")<0) {
    security_note(0, data:"Package w3m-img version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"w3m-m17n");
if(!isnull(bver) && revcomp(a:bver, b:"0.5.1_6")<0) {
    security_note(0, data:"Package w3m-m17n version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"w3m-m17n-img");
if(!isnull(bver) && revcomp(a:bver, b:"0.5.1_6")<0) {
    security_note(0, data:"Package w3m-m17n-img version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ja-w3m");
if(!isnull(bver) && revcomp(a:bver, b:"0.5.1_6")<0) {
    security_note(0, data:"Package ja-w3m version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ja-w3m-img");
if(!isnull(bver) && revcomp(a:bver, b:"0.5.1_6")<0) {
    security_note(0, data:"Package ja-w3m-img version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
