#
#VID bb0a8795-15dc-11df-bf0a-002170daae37
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID bb0a8795-15dc-11df-bf0a-002170daae37
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66814);
 script_cve_id("CVE-2010-0304");
 script_version ("$Revision$");
 script_name("FreeBSD Ports: wireshark, wireshark-lite");

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   wireshark
   wireshark-lite

CVE-2010-0304
Multiple buffer overflows in the LWRES dissector in Wireshark 0.9.15
through 1.0.10 and 1.2.0 through 1.2.5 allow remote attackers to cause
a denial of service (crash) via a malformed packet, as demonstrated
using a stack-based buffer overflow to the
dissect_getaddrsbyname_request function.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://secunia.com/advisories/38257/
http://www.wireshark.org/security/wnpa-sec-2010-02.html
http://www.vuxml.org/freebsd/bb0a8795-15dc-11df-bf0a-002170daae37.html

Risk factor : High";

 script_description(desc);

 script_summary("FreeBSD Ports: wireshark, wireshark-lite");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com");
 script_family("FreeBSD Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"wireshark");
if(!isnull(bver) && revcomp(a:bver, b:"1.2.6")<0) {
    security_note(0, data:"Package wireshark version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"wireshark-lite");
if(!isnull(bver) && revcomp(a:bver, b:"1.2.6")<0) {
    security_note(0, data:"Package wireshark-lite version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
