#
#VID 24eee285-09c7-11da-bc08-0001020eed82
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55046);
 script_cve_id("CVE-2005-2097");
 script_bugtraq_id(14529);
 script_version ("$");
 name = "FreeBSD Ports: xpdf";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   xpdf
   kdegraphics
   gpdf
   cups-base

Solution:
Update your system with the appropriate patches or
software upgrades.

http://rhn.redhat.com/errata/RHSA-2005-670.html
http://www.kde.org/info/security/advisory-20050809-1.txt
http://www.vuxml.org/freebsd/24eee285-09c7-11da-bc08-0001020eed82.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: xpdf";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"xpdf");
if(!isnull(bver) && revcomp(a:bver, b:"3.00_7")<0) {
    security_note(0, data:"Package xpdf version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"kdegraphics");
if(!isnull(bver) && revcomp(a:bver, b:"3.4.2")<0) {
    security_note(0, data:"Package kdegraphics version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"gpdf");
if(!isnull(bver) && revcomp(a:bver, b:"0")>0) {
    security_note(0, data:"Package gpdf version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"cups-base");
if(!isnull(bver) && revcomp(a:bver, b:"0")>0) {
    security_note(0, data:"Package cups-base version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
