#
#ADV FreeBSD-SA-07:03.ipv6.asc
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#
                                                                                
if(description)
{
 script_id(58247);
 script_cve_id("CVE-2007-2242");
 script_version ("$");
 name = "FreeBSD Security Advisory (FreeBSD-SA-07:03.ipv6.asc)";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory FreeBSD-SA-07:03.ipv6.asc

IPv6 provides a routing header option which allows a packet sender to
indicate how the packet should be routed, overriding the routing knowledge
present in a network.  This functionality is roughly equivalent to the
source routing option in IPv4.  All nodes in an IPv6 network -- both
routers and hosts -- are required by RFC 2640 to process such headers.

There is no mechanism for preventing IPv6 routing headers from being used
to route packets over the same link(s) many times.

Solution:
Upgrade your system to the appropriate stable release
or security branch dated after the correction date

https://secure1.securityspace.com/smysecure/catid.html?in=FreeBSD-SA-07:03.ipv6.asc
Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Security Advisory (FreeBSD-SA-07:03.ipv6.asc)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdpatchlevel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
if(patchlevelcmp(rel:"6.2", patchlevel:"4")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"6.1", patchlevel:"16")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"5.5", patchlevel:"12")<0) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
