#
#ADV FreeBSD-SA-06:22.openssh.asc
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#
                                                                                
if(description)
{
 script_id(57476);
 script_cve_id("CVE-2006-4924");
 script_version ("$");
 name = "FreeBSD Security Advisory (FreeBSD-SA-06:22.openssh.asc)";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory FreeBSD-SA-06:22.openssh.asc

OpenSSH is an implementation of the SSH protocol suite, providing an
encrypted, authenticated transport for a variety of services,
including remote shell access.

The CRC compensation attack detector in the sshd(8) daemon, upon receipt
of duplicate blocks, uses CPU time cubic in the number of duplicate
blocks received.  [CVE-2006-4924]

A race condition exists in a signal handler used by the sshd(8) daemon
to handle the LoginGraceTime option, which can potentially cause some
cleanup routines to be executed multiple times.  [CVE-2006-5051]

Solution:
Upgrade your system to the appropriate stable release
or security branch dated after the correction date

https://secure1.securityspace.com/smysecure/catid.html?in=FreeBSD-SA-06:22.openssh.asc
Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Security Advisory (FreeBSD-SA-06:22.openssh.asc)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdpatchlevel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
if(patchlevelcmp(rel:"6.1", patchlevel:"10")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"6.0", patchlevel:"15")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"5.5", patchlevel:"8")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"5.4", patchlevel:"22")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"5.3", patchlevel:"37")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"4.11", patchlevel:"25")<0) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
