#
#ADV FreeBSD-SA-09:13.pipe.asc
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from ADV FreeBSD-SA-09:13.pipe.asc
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(65013);
 script_version ("$");
 script_name("FreeBSD Security Advisory (FreeBSD-SA-09:13.pipe.asc)");

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory FreeBSD-SA-09:13.pipe.asc

Pipes are a form of inter-process communication (IPC) provided by the
FreeBSD kernel.  kqueue is an event management API that applications can
use to monitor pipes and other kernel services.

A race condition exists in the pipe close() code relating to kqueues,
causing use-after-free for kernel memory, which may lead to an
exploitable NULL pointer vulnerability in the kernel, kernel memory
corruption, and other unpredictable results.

Solution:
Upgrade your system to the appropriate stable release
or security branch dated after the correction date

https://secure1.securityspace.com/smysecure/catid.html?in=FreeBSD-SA-09:13.pipe.asc
Risk factor : High";

 script_description(desc);

 script_summary("FreeBSD Security Advisory (FreeBSD-SA-09:13.pipe.asc)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("FreeBSD Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdpatchlevel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
if(patchlevelcmp(rel:"6.4", patchlevel:"7")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"6.3", patchlevel:"13")<0) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
