#
#ADV FreeBSD-SA-04:17.procfs.asc
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#
                                                                                
if(description)
{
 script_id(52659);
 script_bugtraq_id(11789);
 script_cve_id("CVE-2004-1066");
 script_version ("$");
 name = "FreeBSD Security Advisory (FreeBSD-SA-04:17.procfs.asc)";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory FreeBSD-SA-04:17.procfs.asc

The process file system, procfs(5), implements a view of the system
process table inside the file system.  It is normally mounted on
/proc, and is required for the complete operation of programs such as
ps(1) and w(1).

The Linux process file system, linprocfs(5), emulates a subset of
Linux's process file system and is required for the complete operation
of some Linux binaries.

The implementation of the /proc/curproc/cmdline pseudofile in the procfs(5)
file system on FreeBSD 4.x and 5.x, and of the /proc/self/cmdline
pseudofile in the linprocfs(5) file system on FreeBSD 5.x reads a process'
argument vector from the process address space.  During this operation,
a pointer was dereferenced directly without the necessary validation
steps being performed.

Solution:
Upgrade your system to the appropriate stable release
or security branch dated after the correction date

https://secure1.securityspace.com/smysecure/catid.html?in=FreeBSD-SA-04:17.procfs.asc
Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Security Advisory (FreeBSD-SA-04:17.procfs.asc)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdpatchlevel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
if(patchlevelcmp(rel:"5.3", patchlevel:"2")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"5.2.1", patchlevel:"13")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"4.10", patchlevel:"5")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"4.8", patchlevel:"27")<0) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
