###############################################################################
# OpenVAS Vulnerability Test
# $Id: gallarific_28163.nasl 5854 2009-11-13 11:21:24Z mime $
#
# Gallarific Cross Site Scripting and Authentication Bypass Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100309);
 script_bugtraq_id(28163);
 script_version ("1.0-$Revision: 5854 $");

 script_name("Gallarific Cross Site Scripting and Authentication Bypass Vulnerabilities");

desc = "Overview:
Gallarific is prone to a cross-site scripting vulnerability and
multiple authentication-bypass vulnerabilities.

An attacker may leverage these issues to execute arbitrary script code
in the browser of an unsuspecting user in the context of the affected
site, steal cookie-based authentication credentials, add new
categories, add new users, and modify existing users. Other attacks
are also possible.

These issues affect both the commercial and the free versions of
Gallarific.

Solution:
Updates are available. Please contact the vendor for details.

References:
http://www.securityfocus.com/bid/28163
http://www.gallarific.com/download.php

Risk factor : Low";

 script_description(desc);
 script_summary("Determine if Gallarific is prone to multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");
   
port = get_http_port(default:80);
if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

dirs = make_list("/photos","/gallery",cgi_dirs());

foreach dir (dirs) {
   
  url =  string(dir,'/search.php?dosearch=true&query="><script>alert(document.cookie)</script>'); 
  req = http_get(item:url, port:port);
  buf = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);  
  if( buf == NULL )continue;

  if(egrep(pattern: "<script>alert\(document\.cookie\)</script>", string: buf, icase: TRUE)) {
     
    security_warning(port:port);
    exit(0);

  }
}

exit(0);

