###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_adobe_prdts_detect_lin.nasl 0301 2008-10-03 11:21:44Z sep $
#
# VMware products version detection (Linux)
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800108);
  script_version("$Revision: 1.1 $");
  script_name("Adobe products version detection (Linux)");
  desc ="
  Overview : This script retrieves all Adobe Products version and saves
  those in KB.

  Risk factor : Informational";

  script_description(desc);
  script_summary("Set the Versions of Adobe Products");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("General");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

adobePath = find_file(file_name:"AcroVersion", file_path:"/", useregex=TRUE,
                      regexpar:"$", sock:sock);
foreach path (adobePath)
{
  path = chomp(path);
  adobeVer = get_bin_version(full_prog_name:"cat", version_argv:path,
                               ver_pattern:"[0-9.]+(_SU[0-9])?");
  if(adobeVer)
  {
    set_kb_item(name:"Adobe/Reader/Linux/Version", value:adobeVer[0]);
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
