###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_adobe_prdts_mult_vuln_feb10_lin.nasl 7295 2010-02-16 12:24:34Z feb $
#
# Adobe Flash Player/Air Multiple Vulnerabilities - feb10 (Linux)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800476);
  script_version("$Revision: 6788 $: 1.0");
  script_cve_id("CVE-2010-0186", "CVE-2010-0187");
  script_bugtraq_id(38198, 38200);
  script_name("Adobe Flash Player/Air Multiple Vulnerabilities -feb10 (Linux)");
  desc = "
  Overview: This host is installed with Adobe Flash Player/Air and is prone to
  multiple vulnerabilities.

  Vulnerability Insight:
  Cross domain vulnerabilities present in Adobe Flash Player/Adobe Air allows
  remote attackers to bypass intended sandbox restrictions and make
  cross-domain requests via unspecified vectors.

  Impact:
  Successful exploitation will let the remote attackers to crash the application,
  denying service to legitimate users.

  Impact Level: Application

  Affected Software/OS:
  Adobe AIR version prior to 1.5.3.9130
  Adobe Flash Player 10 version prior to 10.0.45.2 on Windows

  Fix: Update to Adobe Air 1.5.3.9130 or Adobe Flash Player 10.0.45.2
  http://get.adobe.com/air
  http://www.adobe.com/support/flashplayer/downloads.html

  References:
  https://bugzilla.redhat.com/show_bug.cgi?id=563819
  http://www.adobe.com/support/security/bulletins/apsb10-06.html

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Adobe Flash Player/Air");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 Greenbone Networks GmbH");
  script_family("General");
  script_dependencies("gb_adobe_flash_player_detect_lin.nasl");
  script_require_keys("AdobeFlashPlayer/Linux/Ver", "Adobe/Air/Linux/Ver");
  exit(0);
}


include("version_func.inc");

# Check for Adobe Flash Player
playerVer = get_kb_item("AdobeFlashPlayer/Linux/Ver");
if(playerVer != NULL)
{
  # Grep for version 10.x < 10.0.45.2
  if(version_in_range(version:playerVer, test_version:"10.0", test_version2:"10.0.45.1"))
  {
    security_hole(0);
    exit(0);
  }
}

# Check for Adobe Air
airVer = get_kb_item("Adobe/Air/Linux/Ver");
if(airVer != NULL)
{
  # Grep for version < 1.5.3.9130
  if(version_is_less(version:airVer, test_version:"1.5.3.9130")){
    security_hole(0);
  }
}
