###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_adobe_shockwave_player_mult_code_exe_vuln.nasl 937 2009-11-06 12:24:24Z nov $
#
# Adobe Shockwave Player Multiple Remote Code Execution Vulnerabilities
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800971);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3463", "CVE-2009-3464", "CVE-2009-3465",
                "CVE-2009-3466");
  script_bugtraq_id(36905);
  script_name("Adobe Shockwave Player Multiple Remote Code Execution Vulnerabilities");
  desc = "
  Overview: This host is installed with Adobe Shockwave Player and is prone
  to Multiple Remote Code Execution Vulnerabilities.

  Vulnerability Insight:
  - Multiple errors ocur due to the use of invalid index and invalid pointer
    while processing specially crafted Shockwave content.
  - An error while processing invalid string lenghts can result in memory
    corruption.

  Impact:
  Successful exploitation will let the attacker execute arbitrary code in the
  context of the affected application by tricking a user into visiting a
  specially crafted web page.

  Impact Level: Application.

  Affected Software/OS:
  Adobe Shockwave Player prior to 11.5.2.602 on Windows.

  Fix: Upgrade to Adobe Shockwave Player 11.5.2.602
  http://get.adobe.com/shockwave/otherversions/

  References:
  http://www.vupen.com/english/advisories/2009/3134
  http://securitytracker.com/alerts/2009/Nov/1023123.html
  http://www.adobe.com/support/security/bulletins/apsb09-16.html

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.8
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Adobe Shockwave Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_family("General");
  script_dependencies("secpod_adobe_shockwave_player_detect.nasl");
  script_require_keys("Adobe/ShockwavePlayer/Ver");
  exit(0);
}


include("version_func.inc");

shockVer = get_kb_item("Adobe/ShockwavePlayer/Ver");
if(!shockVer){
  exit(0);
}

# Check for versions prior to 11.5.2.602
if(version_is_less(version:shockVer, test_version:"11.5.2.602")){
  security_hole(0);
}
