###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_an_guestbook_detect.nasl 3174 2009-06-30 10:58:24Z may $
#
# AN Guestbook Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800523);
  script_version("Revision: 1.0-$Revision: 6400 $");
  script_name("AN Guestbook Version Detection");
  desc = "
  Overview: This script detects the installed version of AN Guestbook and
  sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Sets the KB for the version of AN Guestbook");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

wwwPort = get_http_port(default:80);
if(!wwwPort){
  exit(0);
}

foreach dir (make_list("/ag", "/ang", "/guestbook", "/anguestbook", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/index.php"), port:wwwPort);
  rcvRes = http_send_recv(port:wwwPort, data:sndReq);
  if(("AG" >< rcvRes) && ("version" >< rcvRes)){
    angVer = eregmatch(pattern:"AG(</a>)? - version ([0-9.]+)", string:rcvRes);
  }
  else
  {
    sndReq = http_get(item:string(dir, "/ang/index.php"), port:wwwPort);
    rcvRes = http_send_recv(port:wwwPort, data:sndReq);
    if(("Powered by" >< rcvRes) && ("ANG" >< rcvRes)){
      angVer = eregmatch(pattern:"Powered by.*ANG(</a>)? ([0-9.]+)", string:rcvRes);
    }
  }

  if(angVer[2]!= NULL)
  {
    set_kb_item(name:"www/" + wwwPort + "/AN-Guestbook",
                value:angVer[2] + " under " + dir);
    exit(0);
  }
}
