###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_apache_mod_proxy_dos_vuln.nasl 3286 2009-07-06 13:34:34Z jul $
#
# Apache 'mod_proxy_http.c' Denial Of Service Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800827);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1890");
  script_bugtraq_id(35565);
  script_name("Apache 'mod_proxy_http.c' Denial Of Service Vulnerability");
  desc = "

  Overview:
  This host is running Apache HTTP Server and is prone to Denial of Service
  vulnerability.

  Vulnerability Insight:
  The flaw is due to error in 'stream_reqbody_cl' function in 'mod_proxy_http.c'
  in the mod_proxy module. When a reverse proxy is configured, it does not properly
  handle an amount of streamed data that exceeds the Content-Length value via
  crafted requests.

  Impact:
  Successful exploitation will allow remote attackers to cause Denial of Service
  to the legitimate user by CPU consumption.

  Impact Level: Application

  Affected Software/OS:
  Apache HTTP Server version prior to 2.3.3

  Fix:
  Fixed in the SVN repository.
  http://svn.apache.org/viewvc?view=rev&revision=790587

  References:
  http://secunia.com/advisories/35691
  http://www.vupen.com/english/advisories/2009/1773
  http://svn.apache.org/viewvc/httpd/httpd/trunk/CHANGES?r1=790587&r2=790586&pathrev=790587

  CVSS Score:
    CVSS Base Score      : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score  : 3.7
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check version of Apache HTTP Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_apache_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

httpdPort = get_http_port(default:80);
if(httpdPort == NULL){
  exit(0);
}

httpdVer = get_kb_item("www/" + httpdPort + "/Apache");
if(httpdVer == NULL){
  exit(0);
}

if(version_is_less(version:httpdVer, test_version:"2.3.3")){
  security_warning(httpdPort);
}
