##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_apache_tomcat_mult_vuln_jun09.nasl 2736 2009-06-13 22:40:40Z jun $
#
# Apache Tomcat Multiple Vulnerabilities June-09
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800813);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0033", "CVE-2009-0580", "CVE-2009-0783","CVE-2008-5515");
  script_bugtraq_id(35193, 35196);
  script_name("Apache Tomcat Multiple Vulnerabilities June-09");
  desc = "

  Overview: This host is running Apache Tomcat Server and is prone to
  multiple vulnerabilities.

  Vulnerability Insight:
  Multiple flows are due to,
  - Error in 'XML parser' used for other web applications, which allows local users to
    read or modify the web.xml, context.xml, or tld files via a crafted application
    that is loaded earlier than the target application.
  - when FORM authentication is used, cause enumerate valid usernames via requests
    to /j_security_check with malformed URL encoding of passwords, related to
    improper error checking in the MemoryRealm, DataSourceRealm, and JDBCRealm
    authentication realms, as demonstrated by a % (percent) value for the
    j_password parameter.
  - when the 'Java AJP connector' and 'mod_jk load balancing' are used, via a
    crafted request with invalid headers, related to temporary blocking of
    connectors that have encountered errors, as demonstrated by an error
    involving a malformed HTTP Host header.

  Impact:
  Successful attempt could lead to remote code execution and attacker can gain
  the full permission on affected file, and can cause denial of service.

  Impact Level: System/Application

  Affected Software/OS:
  Apache Tomcat version 6.0.0 to 6.0.18
  Apache Tomcat version 5.5.0 to 5.5.27
  Apache Tomcat version 4.1.0 to 4.1.39

  Fix: Upgrade to Apache Tomcat version 4.1.40, or 5.5.28, or 6.0.20
  http://archive.apache.org/dist/tomcat/

  References:
  http://tomcat.apache.org/security-6.html
  http://tomcat.apache.org/security-5.html
  http://tomcat.apache.org/security-4.html
  http://www.securitytracker.com/id?1022336
  http://www.vupen.com/english/advisories/2009/1496
  http://svn.apache.org/viewvc?view=rev&revision=781708

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.9
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of Apache Tomcat");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_apache_tomcat_detect.nasl");
  script_require_ports("Services/www", 8080);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

tomPort = get_http_port(default:8080);
if(tomPort == NULL){
  exit(0);
}

tomcatVer = get_kb_item("www/" + tomPort + "/ApacheTomcat");
if(tomcatVer == NULL){
  exit(0);
}

# Check Tomcat version < 4.1.40, or < 5.5.28, or < 6.0.20
if(version_in_range(version:tomcatVer, test_version:"4.1.0", test_version2:"4.1.39") ||
   version_in_range(version:tomcatVer, test_version:"5.5.0", test_version2:"5.5.27") ||
   version_in_range(version:tomcatVer, test_version:"6.0.0", test_version2:"6.0.18")){
  security_hole(tomPort);
}
