###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_apple_safari_css_bof_vuln.nasl 6048 2009-12-05 17:17:56Z dec $
#
# Apple Safari 'CSS' Buffer Overflow Vulnerability (Win) - Dec09
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800155);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-4186");
  script_bugtraq_id(37039);
  script_name("Apple Safari 'CSS' Buffer Overflow Vulnerability (Win) - Dec09");
  desc = "
  Overview: This host is installed with Apple Safari Web Browser and is prone
  to Buffer Overflow vulnerability.

  Vulnerability Insight:
  The flaw is due to improper bounds checking while processing Cascading Style Sheets
  background images property.

  Impact:
  Successful exploitation will let the attacker to execute arbitrary code or
  cause the application to crash via long URI value in the CSS background
  property.

  Impact Level: System/Application

  Affected Software/OS:
  Apple Safari version 4.0.3 on Windows.

  Fix:
  No solution or patch is available as on 05th December, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.apple.com/support/downloads

  References:
  http://xforce.iss.net/xforce/xfdb/54487
  http://www.exploit-db.com/exploits/10102

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of Apple Safari");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_family("Buffer overflow");
  script_dependencies("secpod_apple_safari_detect_win_900003.nasl");
  script_require_keys("AppleSafari/Version");
  exit(0);
}

include("version_func.inc");

safariVer = get_kb_item("AppleSafari/Version");
if(safariVer != NULL)
{
  # Check for Apple Safari Version < 4.0.3 (4.31.9.1)
  if(version_is_equal(version:safariVer, test_version:"4.31.9.1")){
    security_hole(0);
  }
}
