###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_apple_safari_dos_vuln_jul09.nasl 3389 2009-07-10 15:28:53Z jul $
#
# Apple Safari Denial Of Service Vulnerability - Jul09
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800656);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2420", "CVE-2009-2421");
  script_name("Apple Safari Denial Of Service Vulnerability - Jul09");
  desc = "

  Overview : The host is installed with Apple Safari web browser and is prone
  to Denial of Service vulnerability.

  Vulnerability Insight:
  The flaws are caused due to,
  - Error in 'CFCharacterSetInitInlineBuffer' method in CoreFoundation.dll
    when processing high-bit character in a URL fragment for an unspecified
    protocol.
  - Error in implementing the file 'protocol handler' when processing vectors
    involving an unspecified HTML tag.

  Impact :
  Successful exploitation allow attackers to execute arbitrary code or can
  even crash the browser.

  Impact Level: Application

  Affected Software/OS:
  Apple Safari 3.2.3 on Windows.

  Fix:
  No solution or patch is available as on 10th July, 2009. Information regarding
  this issue will be updated once the solution details are available.
  For updates refer, http://www.apple.com/support/downloads/

  References:
  http://www.securityfocus.com/archive/1/504479

  CVSS Score:
    CVSS Base Score      : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score  : 7.9
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of Apple Safari");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_apple_safari_detect_win_900003.nasl");
  script_require_keys("AppleSafari/Version");
  exit(0);
}


include("version_func.inc");

safVer = get_kb_item("AppleSafari/Version");
if(!safVer){
  exit(0);
}

# Grep for Apple Safari Version <= 3.2.3 (3.525.29.0)
if(version_is_equal(version:safVer, test_version:"3.525.29.0")){
   security_hole(0);
}
