###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_apple_safari_info_disc_vuln.nasl 853 2009-01-19 10:40:24Z Jan $
#
# Apple Safari RSS Feed Information Disclosure Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800506);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0123");
  script_bugtraq_id(33234);
  script_name("Apple Safari RSS Feed Information Disclosure Vulnerability");
  desc = "

  Overview: The host is running Apple Safari web browser which is prone
  to remote file access vulnerability.

  Vulnerability Insight:
  Flaw is due an error generated in safari web browser while handling feed,
  feeds and feedsearch URL types for RSS feeds.

  Impact:
  Successful remote exploitation can potentially be exploited to gain access
  to sensitive information and launch other attacks.

  Impact Level: System.

  Affected Software/OS:
  Apple Safari 3.1.2 and prior on Windows.

  Fix: No solution or patch is available as on 19th January, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.apple.com/support/downloads/

  References:
  http://en.securitylab.ru/nvd/366491.php
  http://xforce.iss.net/xforce/xfdb/47917
  http://brian.mastenbrook.net/display/27

  CVSS Score:
    CVSS Base Score     : 7.1 (AV:N/AC:M/Au:NR/C:C/I:N/A:N)
    CVSS Temporal Score : 6.1
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of Apple Safari");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("secpod_apple_safari_detect_win_900003.nasl");
  script_require_keys("AppleSafari/Version");
  exit(0);
}


include("version_func.inc");

safVer = get_kb_item("AppleSafari/Version");
if(!safVer){
  exit(0);
}

if(version_is_less_equal(version:safVer, test_version:"3.525.21.0")){
  security_hole(0);
}
